<?
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

set_time_limit(0);

// файл локализации
include(GetLangFileName(dirname(__FILE__) . '/', '/ucs.php'));
// модуль UCS
CModule::IncludeModule('ucs');

// массив с данными по магазину и заказу
$settings = array(
                    'shop_id' => CSalePaySystemAction::GetParamValue('SHOP_ID'),
                    'shop_login' => CSalePaySystemAction::GetParamValue('SHOP_LOGIN'),
                    'shop_pass' => CSalePaySystemAction::GetParamValue('SHOP_PASSWORD'),
                    'shop_url' => CSalePaySystemAction::GetParamValue('SHOP_URL'),
                    'order_id' => IntVal($GLOBALS['SALE_INPUT_PARAMS']['ORDER']['ID']),
                    'shop_fisc' => CSalePaySystemAction::GetParamValue('SHOP_FISC'),
                    'shop_fisc_rate' => CSalePaySystemAction::GetParamValue('SHOP_FISC_RATE'),
);

$soapClient = Cucs::newSoap($settings);
$objStatus = Cucs::getOrderStatus($settings['shop_id'], $settings['order_id']);

// получаем данные по заказу
$arOrder = CSaleOrder::GetByID($settings['order_id']);

try {
    $info = $soapClient->get_status($objStatus);

	switch ($info->status) {
        case 'acknowledged':
        case 'not_acknowledged':
        case 'authorized':
            // заказ успешно оплачен
            Cucs::updatePaymentStatus($order, 'Y', $info->status, $info->status);
            CSaleOrder::StatusOrder($settings['order_id'], CSalePaySystemAction::GetParamValue('PAY_STATUS'));
        break;

        default:
            Cucs::updatePaymentStatus($order, false, $info->status, $info->status);
        break;
    }

} catch (SoapFault $fault) {
    if ($fault->faultstring === 'INVALID_ORDER') {
        // заказ с таким номером не зарегистрирован
        Cucs::updatePaymentStatus($order, 'N', GetMessage('UCS_ORDER_INVALID'), $fault->faultstring);
        CSaleOrder::StatusOrder($settings['order_id'], 'N');
    }
}

return true;